/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.service.ActivityService;
import itx.erp.base.service.UserService;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.AuthorizationException;

public class AppSettingsController
extends BaseController {
    protected ErpConfig appConfig;
    protected UserService userService;
    protected ActivityService activityService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        if (!this.userService.isAdmin(webRequest.getUserId())) {
            throw new AuthorizationException("Only admin allowed");
        }
        this.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("companyName", this.appConfig.getSetting("companyName"));
        settings.put("adminUrl", this.appConfig.getSetting("adminUrl"));
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("success", Boolean.valueOf(true));
        result.put("settings", settings);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        String adminUrl;
        String oldAdminUrl;
        String companyName;
        String oldCompanyName = this.appConfig.getSetting("companyName");
        if (oldCompanyName == null) {
            oldCompanyName = "";
        }
        if (!oldCompanyName.equals(companyName = req.getParameterTrim("companyName"))) {
            this.activityService.createActivity(req.getUserId(), "appsetting-changed", "Company name: " + oldCompanyName + " => " + companyName, "");
            this.appConfig.setSetting("companyName", companyName);
        }
        if ((oldAdminUrl = this.appConfig.getSetting("adminUrl")) == null) {
            oldAdminUrl = "";
        }
        if (!oldAdminUrl.equals(adminUrl = req.getParameterTrim("adminUrl"))) {
            this.activityService.createActivity(req.getUserId(), "appsetting-changed", "Admin url: " + oldAdminUrl + " => " + adminUrl, "");
            this.appConfig.setSetting("adminUrl", adminUrl);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

