/*
 * Decompiled with CFR 0.152.
 */
package itx.core.web.filter;

import itx.core.web.BaseController;
import itx.core.web.filter.RequestFilter;
import itx.core.web.filter.RequestFilterList;
import itx.erp.ErpObjectContainer;
import jtbcore.container.UrlBean;
import jtbcore.exception.AuthorizationException;

public class RequestRouteFilter
implements RequestFilter {
    @Override
    public void execute(RequestFilterList rfl) throws Exception {
        if (rfl.getWebRequest().isRelayRequest()) {
            this.executeRelayRequest(rfl);
        } else {
            this.executeDefaultRequest(rfl);
        }
    }

    protected void executeDefaultRequest(RequestFilterList rfl) throws Exception {
        String routeUrl = rfl.getWebRequest().getRouteUrl();
        ErpObjectContainer objectContainer = ErpObjectContainer.getInstance();
        UrlBean b = objectContainer.lookupUrl(routeUrl);
        BaseController c = null;
        if (b != null) {
            c = objectContainer.getController(b.getRef());
        } else if (routeUrl.startsWith("/static/")) {
            c = objectContainer.getController("staticController");
        } else if (routeUrl.startsWith("/app/")) {
            c = objectContainer.getController("staticController");
        } else if (routeUrl.endsWith("/")) {
            c = objectContainer.getController("appIndexController");
        }
        if (c == null) {
            c = objectContainer.getController("fourOhFourController");
        }
        rfl.getWebRequest().setController(c);
        rfl.next();
    }

    protected void executeRelayRequest(RequestFilterList rfl) throws Exception {
        String routeUrl = rfl.getWebRequest().getRouteUrl();
        ErpObjectContainer objectContainer = ErpObjectContainer.getInstance();
        UrlBean b = objectContainer.lookupUrl(routeUrl);
        BaseController c = null;
        if (b != null) {
            if (!b.getPropertyBool("relay").booleanValue()) {
                throw new AuthorizationException("Route not allowed for relay");
            }
            c = objectContainer.getController(b.getRef());
        }
        if (c == null) {
            c = objectContainer.getController("fourOhFourController");
        }
        rfl.getWebRequest().setController(c);
        rfl.next();
    }
}

